/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.idm.toolkit.expr.test;

import filenet.vw.idm.toolkit.IVWIDMFactory;
import filenet.vw.idm.toolkit.IVWIDMItem;
import filenet.vw.idm.toolkit.IVWIDMLibrary;
import filenet.vw.idm.toolkit.IVWIDMPropertyDescription;
import filenet.vw.idm.toolkit.VWIDMBaseFactory;
import filenet.vw.idm.toolkit.expr.VWIDMExprParser;
import filenet.vw.toolkit.utils.VWCommandLineArgs;

public class Test {
    private IVWIDMFactory m_factory = null;
    private VWCommandLineArgs c = null;
    private IVWIDMLibrary m_lib = null;

    private void PrintUsage() {
        System.out.println("Usage:  ");
        System.out.println(" * Required parameters:");
        System.out.println(" *   webApp = WORKPLACE, OPENCLIENT, PANAGON");
        System.out.println(" *   token, sessionId or");
        System.out.println(" *   name, password, domain");
        System.out.println(" *   webServerURL, webServerUploadURL, webServerDownloadURL, baseURL (optional)");
        System.out.println(" *   id");
        System.out.println(" *   type={document,folder,custom object,stored search} -- default is document");
        System.out.println(" *   libId (GUID or name)");
        System.out.println(" *   expression");
        System.out.println(" *");
        System.out.println(" *   optional:");
        System.out.println(" *      sitePreferences, baseURL");
        System.out.println(" *   See WCM.properties for examples.");
        System.exit(1);
    }

    public Test(String[] args) throws Exception {
        String inputFile;
        if (args != null && args.length == 0) {
            this.PrintUsage();
        }
        this.c = new VWCommandLineArgs(args);
        if (this.c.isPresent("Help") || this.c.isPresent("help")) {
            this.PrintUsage();
        }
        this.c = (inputFile = this.c.getParameter("inputfile")) != null ? new VWCommandLineArgs(inputFile, false) : new VWCommandLineArgs(args, false);
        if (!(this.c.isPresent("libId") && this.c.isPresent("id") && this.c.isPresent("expression"))) {
            this.PrintUsage();
        }
        System.out.println("Got parameters:");
        this.c.list(System.out);
    }

    protected void printProperties(IVWIDMItem item, IVWIDMPropertyDescription[] propDescs) {
        try {
            if (propDescs == null || item == null) {
                return;
            }
            int nProps = propDescs.length;
            System.out.println("------- " + Integer.toString(nProps) + " properties for " + item.getLabel());
            for (int i = 0; i < nProps; ++i) {
                Object value = item.getProp(propDescs[i].getName());
                System.out.println("[" + Integer.toString(i) + "]: " + propDescs[i].getName() + " (" + propDescs[i].getLabel() + ") = " + (value == null ? "NULL VALUE" : value.toString()));
            }
            System.out.println("-----------------------------------------------------------------");
        }
        catch (Throwable t) {
            System.out.println("Ignoring exception:" + t.getMessage());
        }
    }

    public void execute() throws Exception {
        try {
            this.m_factory = VWIDMBaseFactory.instance(this.c);
            this.m_lib = this.m_factory.getIDMLibrary(this.c.getParameter("libId"));
            if (!this.m_lib.isLoggedOn()) {
                this.m_lib.logon(this.c.getParameter("name"), this.c.getParameter("pw"), "");
            }
            String type = this.c.getParameter("type");
            System.out.println(" ------------------------------------------------------ ");
            if (type == null) {
                type = "document";
            }
            String id = this.c.getParameter("id");
            IVWIDMItem m_item = null;
            if (type.equalsIgnoreCase("document")) {
                m_item = this.m_lib.getDocument(id);
                System.out.println("Got a document: " + id);
            } else if (type.equalsIgnoreCase("folder")) {
                m_item = this.m_lib.getFolder(id);
                System.out.println("Got a folder: " + id);
            } else if (type.equalsIgnoreCase("custom object")) {
                m_item = this.m_lib.getCustomObject(id);
                System.out.println("Got a custom object: " + id);
            } else if (type.equalsIgnoreCase("stored search")) {
                m_item = this.m_lib.getStoredSearch(id);
                System.out.println("Got a stored search: " + id);
            }
            String expression = this.c.getParameter("expression");
            System.out.println("Expression='" + expression + "'");
            IVWIDMPropertyDescription[] propDescs = m_item.getPropertyDescriptions();
            if (propDescs != null) {
                if (this.c.isPresent("verbose")) {
                    this.printProperties(m_item, propDescs);
                }
                System.out.println("Validating...");
                String[] validateResults = VWIDMExprParser.validate(expression, propDescs);
                if (validateResults != null) {
                    System.out.println("Validated Results are:");
                    for (int i = 0; i < validateResults.length; ++i) {
                        System.out.println(validateResults[i]);
                    }
                } else {
                    System.out.println("Validated OK.");
                }
            }
            System.out.println("Evaluating...");
            boolean evaluated = VWIDMExprParser.evaluate(expression, m_item);
            System.out.println("Evaluated to " + new Boolean(evaluated).toString());
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                VWIDMBaseFactory.release();
            }
            catch (Exception ex) {}
        }
    }

    public static void main(String[] args) {
        try {
            Test test1 = new Test(args);
            test1.execute();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.exit(1);
    }
}

